# association 
#
# performs association using African American genotypes, African alleles and African minor alleles.

args <- commandArgs(T)

inputdir = args[1]
chr = args[2]
trait = args[3] # first col is IID, then phenotypes; headerline required
cov=args[4] 	# first col is IID, then cov; headerline required; 
outdir = args[5]
admixpop = args[6]
pop1 = args[7]
pop2 = args[8]

"%&%" <- function(a, b){paste(a, b, sep="")}

print("read in input files ...")

trait <- read.table(trait, header = T) 
cov <- read.table(cov, header = T)
pheno <- merge(cov, trait, by="IID")
n.cov <- ncol(cov) - 1

geno    <- read.table(inputdir %&% "/" %&% admixpop %&%".geno." %&% chr)
pop1.allele <- read.table(inputdir %&% "/" %&% pop1 %&% ".allele." %&% chr)
pop1.minor  <- read.table(inputdir %&% "/" %&% pop1 %&% ".minor." %&% chr)
pop2.allele <- read.table(inputdir %&% "/" %&% pop2 %&% ".allele." %&% chr)
pop2.minor  <- read.table(inputdir %&% "/" %&% pop2 %&% ".minor." %&% chr)

print("consist IDs ...")

site.list <- colnames(geno)
dat <- merge(pheno, geno, by.x="IID", by.y=0)
geno <- geno[as.character(dat$IID),]
pop1.allele <- pop1.allele[as.character(dat$IID),]
pop1.minor <- pop1.minor[as.character(dat$IID),]
pop2.allele <- pop2.allele[as.character(dat$IID),]
pop2.minor <- pop2.minor[as.character(dat$IID),]

N <- dim(geno)[1]
m <- dim(geno)[2]

print(N %&% " subjects with " %&% m %&% " markers will be analyzed ...")

trait <- colnames(pheno)[length(pheno)]
covarites <- paste(colnames(pheno)[-c(1,length(pheno))], collapse=" + ")

result.assoc = lapply(site.list, function(x) {
      F_pval=NA
      e = rep(NA, 12)
      n = NA

print(x)

tryCatch({

      # fit null model
      formula = as.formula(trait %&% "~" %&% covarites)
      fit.null <- lm(formula, data=dat)
      
      # fit alternative model
      formula = as.formula(trait %&% "~ geno[,x]+pop1.allele[,x]+pop1.minor[,x]+pop2.allele[,x]+pop2.minor[,x]" %&% covarites)
      fit = lm(formula, data=dat)
      F_pval = anova(fit.null, fit)[2,6] 

      coe <- coef(summary(fit))
      coe.2 <- matrix(NA, nrow=5, ncol=4)
      if ('geno[, x]' %in% rownames(coe)){
      	coe.2[1,] <- coe['geno[, x]',]
      }else{
	coe.2[1,] <- rep(NA, 4)
      }
      if ('pop1.allele[, x]' %in% rownames(coe)){
      	coe.2[2,] <- coe['pop1.allele[, x]',]
      } else {
	coe.2[2,] <- rep(NA, 4)
      }
      if ('pop1.minor[, x]' %in% rownames(coe)){
	coe.2[3,] <- coe['pop1.minor[, x]',]
      } else {
	coe.2[3,] <- rep(NA, 4)
      }
      if ('pop2.allele[, x]' %in% rownames(coe)){
        coe.2[4,] <- coe['pop2.allele[, x]',]
      } else {
        coe.2[4,] <- rep(NA, 4)
      }
      if ('pop2.minor[, x]' %in% rownames(coe)){
        coe.2[5,] <- coe['pop2.minor[, x]',]
      } else {
        coe.2[5,] <- rep(NA, 4)
      }

      e=c(t(coe.2))
      n=nrow(dat)
}, error = function(err){
      print(paste("ERROR:",x,err, sep=" "))
})
      c(F_pval, e, n)
})

print("generate output ...")

pars = c("SNP", "F_pval", 
	"beta_geno", "se_geno", "t_geno", "pval_geno", 
      "beta_"%&% pop1 %&%"_allele", "se_"%&% pop1 %&%"_allele", "t_"%&% pop1 %&%"_allele", "pval_"%&% pop1 %&%"_allele", 
	"beta_"%&% pop1 %&%"_minor", "se_"%&% pop1 %&%"_minor", "t_"%&% pop1 %&%"_minor", "pval_"%&% pop1 %&%"_minor",
	"beta_"%&% pop2 %&%"_allele", "se_"%&% pop2 %&%"_allele", "t_"%&% pop2 %&%"_allele", "pval_"%&% pop2 %&%"_allele",
        "beta_"%&% pop2 %&%"_minor", "se_"%&% pop2 %&%"_minor", "t_"%&% pop2 %&%"_minor", "pval_"%&% pop2 %&%"_minor", "N")

outfile = outdir %&% "/" %&% chr %&% ".assoc.txt"

cat(pars, file=outfile, sep="\t", "\n")
i = 1
for (s in site.list) {
      cat(s, result.assoc[[i]], file=outfile, sep="\t", append=TRUE, "\n")
      i = i+1
}






