#!/usr/bin/perl -w 
#This converts a phased eigenstrat file with data for one chromosomes and
# a correspg SNP file into a Hapmix format genotype file: Used for parental samples

$infile = $ARGV[0];
$snpfile = $ARGV[1];
$label = $ARGV[2];
$chr = $ARGV[3];
$admixpop = $ARGV[4];

if(($#ARGV +1)!= 5) 
  { 
    print "WRONG USAGE: perl convert_phasedeghapmix_chr.pl ingenotypefile insnpfile parentlabel  chr_num admixpop\n"; 
    exit(1); 
  } 
 

open(FILEONE ,$infile)||die("File $infile not found");
open(SNPFILE ,$snpfile)||die("File $snpfile not found");

#Error if files not of same length
@row= <SNPFILE>;
$nsnps = scalar @row;
@row1 = <FILEONE>;
$lengeno = scalar @row1; 
if($lengeno != $nsnps) 
  { 
    print "ERROR: Parental $infile and $snpfile files are not of the same length\t", $lengeno,"\t", $nsnps,"\n";  
    exit(1);  
  } 



#Read in the physical positions from the SNP file
for($i =0; $i < scalar @row;$i++ )
  {
    chomp($row[$i]);
    @data = split(' ',$row[$i]);
    $physpos[$i] = $data[3];
  }

#Read in the genotye file
$j = 0;
while($j < scalar @row1)
  {
	
    chomp($row1[$j]);
    @data = split('',$row1[$j]);
    $nind = scalar @data;
    for($i=0; $i<scalar @data; $i++)
      {
	if($data[$i] eq '9') 
	  { 
	    $data[$i] = '?';   
	  } 
	$geno[$i][$j] = $data[$i];

      }
    $j++;
}    

#Create the Hapmix style genotyep files
$genofile = $admixpop.".".$label."GENOOUT.$chr";
open(GENOFILE ,">$genofile")||die("Unable to make file $genofile");  
      
print GENOFILE ":sites:".$nsnps,"\n";
print GENOFILE ":sequences:".$nind,"\n";
    
for($j=0;$j<$nsnps;$j++)
  {
    print GENOFILE $physpos[$j]," ";
  }
print GENOFILE "\n";
    
for($i = 0; $i < $nind; $i++)
  {
    for($j=0;$j < $nsnps;$j++)
      {
	print GENOFILE $geno[$i][$j];
      }
    print GENOFILE "\n";
  }
  
print "Finished writing Parental file ",$label," for CHR NUM $chr\n"; 
close FILEONE;
close SNPFILE;
close GENOFILE;

exit(0);
